/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.domain.use_case;

import com.android.payment.domain.mapper.SettlementMapper;
import com.android.payment.domain.model.SettlementDto;
import com.android.payment.domain.use_case.QuerySettlementCheques;
import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class QuerySettlements {
    private final DbConnection dbConnection;
    @Resource
    @Lazy
    private QuerySettlementCheques querySettlementCheques;

    public List<SettlementDto> invoke(String sql, LoginDto login) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        List dtoList = jdbc.query(sql, (RowMapper)new SettlementMapper());
        List chequeList = this.querySettlementCheques.invoke(dtoList.stream().map(dto -> String.valueOf(dto.getId())).collect(Collectors.toList()));
        return dtoList.stream().peek(dto -> dto.setCheckDtoList(chequeList.stream().filter(cheque -> cheque.getDocumentCode().equals(String.valueOf(dto.getId()))).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public QuerySettlements(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

